/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import tech.thatgravyboat.duckling.client.rendering.DuckModel;
import tech.thatgravyboat.duckling.common.entity.DuckEntity;

public class DuckRenderer
extends GeoEntityRenderer<DuckEntity> {
    public DuckRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (AnimatedGeoModel)new DuckModel());
    }

    public void renderEarly(DuckEntity animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        super.renderEarly((LivingEntity)animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
        if (animatable.m_6162_()) {
            stackIn.m_85841_(0.5f, 0.5f, 0.5f);
        }
    }

    public void render(DuckEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        Entity holdingEntity = entity.m_21524_();
        if (holdingEntity != null) {
            this.renderLeash(entity, partialTicks, stack, bufferIn, holdingEntity);
        }
    }

    public RenderType getRenderType(DuckEntity animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)textureLocation);
    }

    private <E extends Entity> void renderLeash(DuckEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource provider, E holdingEntity) {
        int u;
        matrices.m_85836_();
        Vec3 vec3d = holdingEntity.m_7398_(tickDelta);
        double d = (double)(Mth.m_14179_((float)tickDelta, (float)entity.f_20883_, (float)entity.f_20884_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec3d2 = entity.m_7939_();
        double e = Math.cos(d) * vec3d2.f_82481_ + Math.sin(d) * vec3d2.f_82479_;
        double f = Math.sin(d) * vec3d2.f_82481_ - Math.cos(d) * vec3d2.f_82479_;
        double g = Mth.m_14139_((double)tickDelta, (double)entity.f_19854_, (double)entity.m_20185_()) + e;
        double h = Mth.m_14139_((double)tickDelta, (double)entity.f_19855_, (double)entity.m_20186_()) + vec3d2.f_82480_;
        double i = Mth.m_14139_((double)tickDelta, (double)entity.f_19856_, (double)entity.m_20189_()) + f;
        matrices.m_85837_(e, vec3d2.f_82480_, f);
        float j = (float)(vec3d.f_82479_ - g);
        float k = (float)(vec3d.f_82480_ - h);
        float l = (float)(vec3d.f_82481_ - i);
        float m = 0.025f;
        VertexConsumer vertexConsumer = provider.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = matrices.m_85850_().m_85861_();
        float n = Mth.m_14195_((float)(j * j + l * l)) * 0.025f / 2.0f;
        float o = l * n;
        float p = j * n;
        BlockPos blockPos = new BlockPos(entity.m_20299_(tickDelta));
        BlockPos blockPos2 = new BlockPos(holdingEntity.m_20299_(tickDelta));
        int q = this.m_6086_((Entity)entity, blockPos);
        int r = holdingEntity.m_6060_() ? 15 : holdingEntity.f_19853_.m_45517_(LightLayer.BLOCK, blockPos2);
        int s = entity.f_19853_.m_45517_(LightLayer.SKY, blockPos);
        int t = entity.f_19853_.m_45517_(LightLayer.SKY, blockPos2);
        for (u = 0; u <= 24; ++u) {
            DuckRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.025f, o, p, u, false);
        }
        for (u = 24; u >= 0; --u) {
            DuckRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.0f, o, p, u, true);
        }
        matrices.m_85849_();
    }

    private static void renderLeashPiece(VertexConsumer vertexConsumer, Matrix4f positionMatrix, float f, float g, float h, int leashedEntityBlockLight, int holdingEntityBlockLight, int leashedEntitySkyLight, int holdingEntitySkyLight, float i, float j, float k, float l, int pieceIndex, boolean isLeashKnot) {
        float m = (float)pieceIndex / 24.0f;
        int n = (int)Mth.m_14179_((float)m, (float)leashedEntityBlockLight, (float)holdingEntityBlockLight);
        int o = (int)Mth.m_14179_((float)m, (float)leashedEntitySkyLight, (float)holdingEntitySkyLight);
        int p = LightTexture.m_109885_((int)n, (int)o);
        float q = pieceIndex % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float r = 0.5f * q;
        float s = 0.4f * q;
        float t = 0.3f * q;
        float u = f * m;
        float v = g > 0.0f ? g * m * m : g - g * (1.0f - m) * (1.0f - m);
        float w = h * m;
        vertexConsumer.m_85982_(positionMatrix, u - k, v + j, w + l).m_85950_(r, s, t, 1.0f).m_85969_(p).m_5752_();
        vertexConsumer.m_85982_(positionMatrix, u + k, v + i - j, w - l).m_85950_(r, s, t, 1.0f).m_85969_(p).m_5752_();
    }
}

